create or replace function tbicds.getPatientEthnicityList(pi_vPatientID in varchar2) return varchar2
AUTHID CURRENT_USER
is
   v_vSql                               varchar2(4000);
   rc                                   sys_refcursor;
   v_nValue                             number;
   v_vList                              varchar(255) := ',';
begin
   v_vSql := 'select t.ethnicity_id from tbicds.patient_ethnicity t where t.patient_id = :P0';
   open rc for v_vSql using pi_vPatientID;
   loop
      fetch rc into v_nValue;
      exit when rc%notfound;
      
      v_vList := v_vList || v_nValue || ',';
   end loop;
   close rc;
   
   return v_vList;
   
exception
   when others then
      return null;
end;
/

